<?php $__env->startSection('main_content'); ?>
<?php echo $__env->make('admin.layouts.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('admin.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="main-content">
    <section class="section">
        <div class="section-header d-flex justify-content-between">
            <h1><?php echo e(__('Edit Project')); ?></h1>
            <div class="ml-auto">
                <a href="<?php echo e(route('admin_project_index')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('View All')); ?></a>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('admin_project_update', $project->id)); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Existing Photo')); ?></label>
                                        <div>
                                            <img src="<?php echo e(asset('uploads/'.$project->photo)); ?>" alt="" class="w_200">
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Change Photo')); ?></label>
                                        <div><input type="file" name="photo" class="form-control"></div>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Title')); ?> *</label>
                                        <input type="text" name="title" class="form-control" value="<?php echo e($project->title); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Slug')); ?> *</label>
                                        <input type="text" name="slug" class="form-control" value="<?php echo e($project->slug); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Short Description')); ?> *</label>
                                        <textarea name="short_description" class="form-control h_100"><?php echo e($project->short_description); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Description')); ?> *</label>
                                        <textarea name="description" class="form-control editor"><?php echo e($project->description); ?></textarea>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Date')); ?> *</label>
                                        <input type="text" name="project_date" class="form-control" value="<?php echo e($project->project_date); ?>">
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Client')); ?> *</label>
                                        <input type="text" name="client" class="form-control" value="<?php echo e($project->client); ?>">
                                    </div>
                                    <div class="col-lg-4 mb-3">
                                        <label for=""><?php echo e(__('Location')); ?></label>
                                        <input type="text" name="location" class="form-control" value="<?php echo e($project->location); ?>">
                                    </div>
                                    <div class="col-lg-4 mb-3">
                                        <label for=""><?php echo e(__('Website')); ?></label>
                                        <input type="text" name="website" class="form-control" value="<?php echo e($project->website); ?>">
                                    </div>
                                    <div class="col-lg-4 mb-3">
                                        <label for=""><?php echo e(__('Phone')); ?></label>
                                        <input type="text" name="phone" class="form-control" value="<?php echo e($project->phone); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Quote Person')); ?></label>
                                        <input type="text" name="quote_person" class="form-control" value="<?php echo e($project->quote_person); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Quote Text')); ?></label>
                                        <textarea name="quote_text" class="form-control h_100"><?php echo e($project->quote_text); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('SEO Title')); ?></label>
                                        <input type="text" name="seo_title" class="form-control" value="<?php echo e($project->seo_title); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('SEO Meta Description')); ?></label>
                                        <textarea name="seo_meta_description" class="form-control h_100"><?php echo e($project->seo_meta_description); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/admin/project/edit.blade.php ENDPATH**/ ?>