<?php $__env->startSection('main_content'); ?>
<?php echo $__env->make('admin.layouts.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('admin.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="main-content">
    <section class="section">
        <div class="section-header d-flex justify-content-between">
            <h1><?php echo e(__('Edit Post')); ?></h1>
            <div class="ml-auto">
                <a href="<?php echo e(route('admin_post_index')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('View All')); ?></a>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('admin_post_update', $post->id)); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Existing Photo')); ?></label>
                                        <div>
                                            <img src="<?php echo e(asset('uploads/'.$post->photo)); ?>" alt="" class="w_200">
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Change Photo')); ?></label>
                                        <div><input type="file" name="photo" class="form-control"></div>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Title')); ?> *</label>
                                        <input type="text" name="title" class="form-control" value="<?php echo e($post->title); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Slug')); ?> *</label>
                                        <input type="text" name="slug" class="form-control" value="<?php echo e($post->slug); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Short Description')); ?> *</label>
                                        <textarea name="short_description" class="form-control h_100"><?php echo e($post->short_description); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Description')); ?> *</label>
                                        <textarea name="description" class="form-control editor h_200"><?php echo e($post->description); ?></textarea>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Category')); ?> *</label>
                                        <select name="post_category_id" class="form-select">
                                            <?php $__currentLoopData = $post_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($post_category->id); ?>" <?php echo e($post->post_category_id == $post_category->id ? 'selected' : ''); ?>><?php echo e($post_category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Tags')); ?></label>
                                        <select name="tags[]" class="form-select select2_tags" multiple="multiple">
                                            <?php $__currentLoopData = $post_tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(trim($tag) !== ''): ?>
                                                    <option value="<?php echo e($tag); ?>" selected><?php echo e($tag); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('SEO Title')); ?></label>
                                        <input type="text" name="seo_title" class="form-control" value="<?php echo e($post->seo_title); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('SEO Meta Description')); ?></label>
                                        <textarea name="seo_meta_description" class="form-control h_100"><?php echo e($post->seo_meta_description); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/admin/post/edit.blade.php ENDPATH**/ ?>