<?php $__env->startSection('main_content'); ?>
<!--==============================
Breadcrumb Area
==============================-->
<section class="breadcrumb__area fix" data-background="<?php echo e(asset('uploads/'.$global_setting->banner)); ?>">
    <div class="breadcrumb__bg-shape"></div>
    <div class="container">
        <div class="row">
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb__content">
                    <h3 class="title"><?php echo e($service->name); ?></h3>
                </div>
            </div>
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb-wrap">
                    <nav class="breadcrumb">
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(route('services')); ?>"><?php echo e($global_page_item->services_page_title); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem"><?php echo e($service->name); ?></span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->


<!--==============================
Service Details Area
==============================-->
<section class="service__details-area pt-120 pb-120">
    <div class="container">
        <div class="row gy-60">
            <div class="col-xl-8 col-lg-7">
                <div class="service__details-wrap">
                    <div class="service__details-thumb mb-45">
                        <div class="thumb">
                            <img src="<?php echo e(asset('uploads/'.$service->photo)); ?>" alt="img">
                        </div>
                    </div>
                    <div class="service__details-content">
                        <h3 class="title mb-15">
                            <?php echo e($service->name); ?>

                        </h3>
                        <p>
                            <?php echo $service->description; ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-5">
                <aside class="blog-sidebar">
                    <div class="blog-widget service-widget">
                        <h4 class="widget-title"><?php echo e(__('Our Services')); ?></h4>
                        <div class="sidebar-cat-list">
                            <ul class="list-wrap">
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('service', $item->slug)); ?>"><?php echo e($item->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <?php if($service->phone): ?>
                    <div class="blog-widget sidebar-banner">
                        <h4 class="widget-title">
                            <?php echo nl2br($global_page_item->service_widget_title); ?>

                        </h4>
                        <p class="banner-text">
                            <?php echo nl2br($global_page_item->service_widget_text); ?>

                        </p>
                        <a class="banner-link" href="tel:<?php echo e($service->phone); ?>"><i class="fas fa-phone"></i> <?php echo e($service->phone); ?></a>
                        <a href="<?php echo e(route('appointment')); ?>" class="btn btn-two w-100"><span class="btn-text" data-text="<?php echo e($global_page_item->service_widget_button_text); ?>"></span> <i class="fas fa-arrow-right"></i></a>
                        </form>
                    </div>
                    <?php endif; ?>
                </aside>
            </div>
        </div>
    </div>
</section>
<!-- Service-details-area-end -->


<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/front/service.blade.php ENDPATH**/ ?>