<?php $__env->startSection('main_content'); ?>
<?php echo $__env->make('admin.layouts.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('admin.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="main-content">
    <section class="section">
        <div class="section-header d-flex justify-content-between">
            <h1><?php echo e(__('Packages')); ?></h1>
            <div class="ml-auto">
                <a href="<?php echo e(route('admin_package_create')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('Add New')); ?></a>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="example1">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('SL')); ?></th>
                                            <th><?php echo e(__('Photo')); ?></th>
                                            <th><?php echo e(__('Name')); ?></th>
                                            <th><?php echo e(__('Price')); ?> <?php echo e($global_setting->currency_symbol); ?></th>
                                            <th><?php echo e(__('Billing Cycle')); ?></th>
                                            <th><?php echo e(__('Features')); ?></th>
                                            <th><?php echo e(__('Action')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td>
                                                <img src="<?php echo e(asset('uploads/'.$package->photo)); ?>" alt="" class="w_150">
                                            </td>
                                            <td><?php echo e($package->name); ?></td>
                                            <td><?php echo e($global_setting->currency_symbol); ?><?php echo e($package->price); ?></td>
                                            <td><?php echo e($package->billing_cycle); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('admin_package_feature_index', $package->id)); ?>" class="btn btn-success btn-sm"><?php echo e(__('Manage Features')); ?></a>
                                            </td>
                                            <td class="pt_10 pb_10">
                                                <a href="<?php echo e(route('admin_package_edit', $package->id)); ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                                <a href="<?php echo e(route('admin_package_destroy', $package->id)); ?>" class="btn btn-danger btn-sm" onClick="return confirm('Are you sure?');"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/phpscriptpoint/lawyer/lawyer/cms/main_files/resources/views/admin/package/index.blade.php ENDPATH**/ ?>