<!doctype html>
<?php if($global_setting->layout_direction == 'LTR'): ?>
<html lang="en" dir="ltr">
<?php else: ?>
<html lang="en" dir="rtl">
<?php endif; ?>
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">

    <title><?php echo e(__('Admin Panel')); ?></title>

    <link rel="icon" type="image/png" href="<?php echo e(asset('uploads/'.$global_setting->favicon)); ?>">
        
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <?php echo $__env->make('admin.layouts.style', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.layouts.script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <style>
        .navbar-bg,
        .section .section-header .btn,
        .section-body button[type="submit"] {
            background-color: #<?php echo e($global_setting->theme_color_1); ?>;
        }
        .section .section-header .btn,
        .section-body button[type="submit"] {
            border-color: #<?php echo e($global_setting->theme_color_1); ?>;
        }
        .sidebar-tabs .nav-link.active,
        .sidebar-tabs .nav-link:hover {
            background-color: #<?php echo e($global_setting->theme_color_1); ?>!important;
        }
    </style>
    
</head>

<body>
<div id="app">
    <div class="main-wrapper">
        <?php echo $__env->yieldContent('main_content'); ?>
    </div>
</div>

<?php echo $__env->make('admin.layouts.script_footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</body>
</html><?php /**PATH /Applications/MAMP/htdocs/phpscriptpoint/lawyer/lawyer/cms/main_files/resources/views/admin/layouts/master.blade.php ENDPATH**/ ?>