<?php $__env->startSection('main_content'); ?>
<!--==============================
Breadcrumb Area
==============================-->
<section class="breadcrumb__area fix" data-background="<?php echo e(asset('uploads/'.$global_setting->banner)); ?>">
    <div class="breadcrumb__bg-shape"></div>
    <div class="container">
        <div class="row">
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb__content">
                    <h3 class="title"><?php echo e($lawyer->name); ?></h3>
                </div>
            </div>
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb-wrap">
                    <nav class="breadcrumb">
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(route('lawyers')); ?>"><?php echo e(__('Lawyers')); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem"><?php echo e($lawyer->name); ?></span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->


<!--==============================
Lawyer Details Area
==============================-->
<section class="lawyer__details-area pt-120 pb-120">
    <div class="container">
        <div class="lawyer__details-wrap">
            <div class="row gx-60 gy-60">
                <div class="col-xl-6">
                    <div class="lawyer__details-thumb">
                        <div class="thumb">
                            <img src="<?php echo e(asset('uploads/'.$lawyer->photo)); ?>" alt="img">
                        </div>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="lawyer__details-content">
                        <h3 class="title mb-15">
                            <?php echo e($lawyer->name); ?>

                        </h3>
                        <h4 class="subtitle mb-30">
                            <?php echo e($lawyer->designation); ?>

                        </h4>
                        <div class="mb-30">
                            <p>
                                <?php echo nl2br($lawyer->biography); ?>

                            </p>
                        </div>
                        <?php if($lawyer->email != '' || $lawyer->phone != ''): ?>
                        <ul class="lawyer-info-wrap">
                            <?php if($lawyer->email): ?>
                            <li>
                                <div class="lawyer-info-card">
                                    <div class="lawyer-info-icon">
                                        <i class="fas fa-envelope"></i>
                                    </div>
                                    <div class="lawyer-info-details">
                                        <p><?php echo e(__('Email')); ?></p>
                                        <h4><?php echo e($lawyer->email); ?></h4>
                                    </div>
                                </div>
                            </li>
                            <?php endif; ?>
                            <?php if($lawyer->phone): ?>
                            <li>
                                <div class="lawyer-info-card">
                                    <div class="lawyer-info-icon">
                                        <i class="fas fa-phone-alt"></i>
                                    </div>
                                    <div class="lawyer-info-details">
                                        <p><?php echo e(__('Phone')); ?></p>
                                        <h4><?php echo e($lawyer->phone); ?></h4>
                                    </div>
                                </div>
                            </li>
                            <?php endif; ?>
                        </ul>
                        <?php endif; ?>

                        <?php if($lawyer->facebook != '' || $lawyer->twitter != '' || $lawyer->linkedin != '' || $lawyer->instagram != ''): ?>
                        <div class="social-links style3 mt-50">
                            <ul class="list-wrap">
                                <?php if($lawyer->facebook): ?>
                                <li><a href="<?php echo e($lawyer->facebook); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                                <?php endif; ?>
                                <?php if($lawyer->twitter): ?>
                                <li><a href="<?php echo e($lawyer->twitter); ?>" target="_blank">
                                    <svg class="d-inline-block" width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M8.33192 5.92804L13.5438 0H12.3087L7.78328 5.14724L4.16883 0H0L5.46575 7.78353L0 14H1.2351L6.01407 8.56431L9.83119 14H14L8.33192 5.92804ZM6.64027 7.85211L6.08648 7.07704L1.68013 0.909771H3.57718L7.13316 5.88696L7.68694 6.66202L12.3093 13.1316H10.4123L6.64027 7.85211Z"
                                            fill="currentColor" />
                                    </svg>
                                </a></li>
                                <?php endif; ?>
                                <?php if($lawyer->linkedin): ?>
                                <li><a href="<?php echo e($lawyer->linkedin); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
                                <?php endif; ?>
                                <?php if($lawyer->instagram): ?>
                                <li><a href="<?php echo e($lawyer->instagram); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li>
                                <?php endif; ?>
                            </ul>
                            <?php endif; ?>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--======== / Lawyer Section ========-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/front/lawyer.blade.php ENDPATH**/ ?>