<?php $__env->startSection('main_content'); ?>
<!--==============================
Breadcrumb Area
==============================-->
<section class="breadcrumb__area fix" data-background="<?php echo e(asset('uploads/'.$global_setting->banner)); ?>">
    <div class="breadcrumb__bg-shape"></div>
    <div class="container">
        <div class="row">
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb__content">
                    <h3 class="title"><?php echo e($global_page_item->lawyers_page_title); ?></h3>
                </div>
            </div>
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb-wrap">
                    <nav class="breadcrumb">
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem"><?php echo e($global_page_item->lawyers_page_title); ?></span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->


<!--==============================
Lawyer Area
==============================-->
<section class="lawyer-area-2 pt-120 pb-120 overflow-hidden">
    <div class="container">
        <div class="row gy-40 justify-content-center">
            <?php $__currentLoopData = $lawyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xl-4 col-md-6">
                <div class="lawyer-card style2">
                    <div class="box-img image-anim">
                        <a href="<?php echo e(route('lawyer',$lawyer->slug)); ?>" class="thumb">
                            <img src="<?php echo e(asset('uploads/'.$lawyer->photo)); ?>" alt="img">
                        </a>
                        <?php if($lawyer->facebook != '' || $lawyer->twitter != '' || $lawyer->linkedin != '' || $lawyer->instagram != ''): ?>
                        <div class="lawyer-social">
                            <button class="icon-btn"><i class="fas fa-share-alt"></i></button>
                            <div class="social-wrap">
                                <?php if($lawyer->facebook): ?>
                                <a target="_blank" href="<?php echo e($lawyer->facebook); ?>" tabindex="-1"><i class="fab fa-facebook-f"></i></a>
                                <?php endif; ?>
                                <?php if($lawyer->twitter): ?>
                                <a target="_blank" href="<?php echo e($lawyer->twitter); ?>" tabindex="-1"><svg class="d-inline-block" width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M8.33192 5.92804L13.5438 0H12.3087L7.78328 5.14724L4.16883 0H0L5.46575 7.78353L0 14H1.2351L6.01407 8.56431L9.83119 14H14L8.33192 5.92804ZM6.64027 7.85211L6.08648 7.07704L1.68013 0.909771H3.57718L7.13316 5.88696L7.68694 6.66202L12.3093 13.1316H10.4123L6.64027 7.85211Z"
                                        fill="currentColor" />
                                </svg></a>
                                <?php endif; ?>
                                <?php if($lawyer->linkedin): ?>
                                <a target="_blank" href="<?php echo e($lawyer->linkedin); ?>" tabindex="-1"><i class="fab fa-linkedin-in"></i></a>
                                <?php endif; ?>
                                <?php if($lawyer->instagram): ?>
                                <a target="_blank" href="<?php echo e($lawyer->instagram); ?>" tabindex="-1"><i class="fab fa-instagram"></i></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="lawyer-card-details">
                        <h4 class="box-title"><a href="<?php echo e(route('lawyer',$lawyer->slug)); ?>"><?php echo e($lawyer->name); ?></a></h4>
                        <span class="box-text"><?php echo e($lawyer->designation); ?></span>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <?php if($lawyers->hasPages()): ?>
        <div class="row">
            <div class="col-lg-12 d-flex justify-content-center">
                <div class="pagination__wrap mt-60">
                    <ul class="list-wrap d-flex flex-wrap">
                        <?php
                            $current = $lawyers->currentPage();
                            $last = $lawyers->lastPage();
                        ?>
                        <?php if(!$lawyers->onFirstPage()): ?>
                            <li>
                                <a href="<?php echo e($lawyers->previousPageUrl()); ?>" class="page-numbers">
                                    <svg width="15" height="13" viewBox="0 0 15 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6 1L0 7M0 7L6 13M0 7H15" stroke="currentColor" stroke-width="1.5"/>
                                    </svg>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php for($page=1;$page<=$last;$page++): ?>
                            <?php if($page === $current): ?>
                                <li><span class="page-numbers current"><?php echo e(sprintf('%02d', $page)); ?></span></li>
                            <?php else: ?>
                                <li><a href="<?php echo e($lawyers->url($page)); ?>" class="page-numbers"><?php echo e(sprintf('%02d', $page)); ?></a></li>
                            <?php endif; ?>
                        <?php endfor; ?>
                        <?php if($lawyers->hasMorePages()): ?>
                            <li>
                                <a href="<?php echo e($lawyers->nextPageUrl()); ?>" class="page-numbers">
                                    <svg width="15" height="13" viewBox="0 0 15 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 1L15 7M15 7L9 13M15 7H0" stroke="currentColor" stroke-width="1.5"/>
                                    </svg>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php endif; ?>


    </div>
</section>
<!--======== / Lawyer Section ========-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/front/lawyers.blade.php ENDPATH**/ ?>